using UnityEngine;
using System.Collections;

public class RocketScript : MonoBehaviour {
	
	public Vector3 speedDirection;
	public float speed;
	public float friction;
	float fa = 10.0f;
	bool enableCollisions = true;
	
	public void Init () {
		rigidbody.velocity = speed * speedDirection;
		Destroy (gameObject, 20.0f);
	}
	
	public void Init (bool collisions) {
		Init();
		enableCollisions = collisions;
	}
	
	void OnDisable() {
		if (enableCollisions) {
			if (GameManagerScript.instance)
				GameManagerScript.instance.SendMessage ("SwitchPlayer");
		}
	}
	
	void FixedUpdate () {
		transform.LookAt (transform.position + rigidbody.velocity, transform.up);
		rigidbody.AddForce((-transform.position / transform.position.sqrMagnitude) * fa - friction * rigidbody.velocity);
	}
	
	void OnCollisionEnter( Collision col ) {
		if (enableCollisions)
		{
			col.gameObject.SendMessage ("YouAreHit", col.contacts[0], SendMessageOptions.DontRequireReceiver);
			Destroy(gameObject);
		}
	}
}
